/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.item;

import java.util.List;
import javax.annotation.Nullable;
import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.capability.ISelection;
import melonslise.locks.common.config.LocksConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.init.LocksSoundEvents;
import melonslise.locks.common.item.LockingItem;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lock;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LocksUtil;
import melonslise.locks.common.util.Orientation;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LockItem
extends LockingItem {
    public final int length;
    public final int enchantmentValue;
    public final float resistance;
    public static final String KEY_LENGTH = "Length";
    public static final String KEY_OPEN = "Open";

    public LockItem(int length, int enchVal, float resist) {
        this.length = length;
        this.enchantmentValue = enchVal;
        this.resistance = resist;
        this.func_185043_a(new ResourceLocation("locks:open"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World world, EntityLivingBase entity) {
                if (stack.func_77973_b() instanceof LockItem) {
                    return LockItem.isOpen(stack) ? 1.0f : 0.0f;
                }
                return 0.0f;
            }
        });
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int func_77619_b() {
        return this.enchantmentValue;
    }

    public static boolean isOpen(ItemStack stack) {
        NBTTagCompound nbt = LocksUtil.getTag(stack);
        if (!nbt.func_74764_b(KEY_OPEN)) {
            nbt.func_74757_a(KEY_OPEN, false);
        }
        return nbt.func_74767_n(KEY_OPEN);
    }

    public static void setOpen(ItemStack stack, boolean open) {
        LocksUtil.getTag(stack).func_74757_a(KEY_OPEN, open);
    }

    public static byte getLength(ItemStack stack) {
        NBTTagCompound nbt = LocksUtil.getTag(stack);
        if (!nbt.func_74764_b(KEY_LENGTH)) {
            return (byte)((LockItem)stack.func_77973_b()).length;
        }
        return nbt.func_74771_c(KEY_LENGTH);
    }

    public static float getResistance(ItemStack stack) {
        return ((LockItem)stack.func_77973_b()).resistance;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        ILockableHandler lockables = (ILockableHandler)world.getCapability(LocksCapabilities.LOCKABLE_HANDLER, null);
        if (!LocksConfig.getServer(world).canLock(world, pos) || lockables.getInChunk(pos).values().stream().anyMatch(lockable1 -> lockable1.box.intersects(pos))) {
            return EnumActionResult.PASS;
        }
        return LocksConfig.getServer((World)world).easyLock ? this.easyLock(lockables, player, world, pos, hand, face, hitX, hitY, hitZ) : this.freeLock(lockables, player, world, pos, hand, face, hitX, hitY, hitZ);
    }

    public EnumActionResult freeLock(ILockableHandler lockables, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        ISelection select = (ISelection)player.getCapability(LocksCapabilities.SELECTION, null);
        ItemStack stack = player.func_184586_b(hand);
        BlockPos pos1 = select.get();
        if (pos1 == null) {
            select.set(pos);
        } else {
            select.set(null);
            world.func_184133_a(player, pos, LocksSoundEvents.LOCK_CLOSE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (world.field_72995_K) {
                return EnumActionResult.SUCCESS;
            }
            ItemStack lockStack = stack.func_77946_l();
            lockStack.func_190920_e(1);
            if (!lockables.add(new Lockable(new Cuboid6i(pos1, pos), Lock.from(lockStack), Orientation.fromDirection(face, player.func_174811_aO().func_176734_d()), lockStack, world))) {
                return EnumActionResult.PASS;
            }
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public EnumActionResult easyLock(ILockableHandler lockables, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        world.func_184133_a(player, pos, LocksSoundEvents.LOCK_CLOSE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        IBlockState state = world.func_180495_p(pos);
        BlockPos pos1 = pos;
        TileEntity te = world.func_175625_s(pos);
        Orientation placedOrientation = Orientation.fromDirection(face, player.func_174811_aO().func_176734_d());
        if (te instanceof TileEntityChest) {
            BlockPos adjPos = LocksUtil.getAdjacentChest((TileEntityChest)te);
            if (adjPos != null) {
                pos1 = adjPos;
            }
            if (LocksConfig.COMMON.automaticallyOrientPlacedLocks && state.func_177230_c() instanceof BlockChest) {
                placedOrientation = Orientation.fromDirection((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockChest.field_176459_a), EnumFacing.NORTH);
            }
        } else if (state.func_177230_c() instanceof BlockDoor) {
            BlockDoor.EnumDoorHalf clickedDoorHalf = (BlockDoor.EnumDoorHalf)state.func_177229_b((IProperty)BlockDoor.field_176523_O);
            BlockDoor.EnumHingePosition clickedDoorHinge = (BlockDoor.EnumHingePosition)state.func_177229_b((IProperty)BlockDoor.field_176521_M);
            EnumFacing clickedDoorFacing = (EnumFacing)state.func_177229_b((IProperty)BlockDoor.field_176520_a);
            boolean isOpen = (Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b);
            pos1 = clickedDoorHalf == BlockDoor.EnumDoorHalf.LOWER ? pos.func_177984_a() : pos.func_177977_b();
            IBlockState otherHalfState = world.func_180495_p(pos1);
            if (clickedDoorHalf == BlockDoor.EnumDoorHalf.UPPER && otherHalfState.func_177230_c() instanceof BlockDoor) {
                isOpen = (Boolean)otherHalfState.func_177229_b((IProperty)BlockDoor.field_176519_b);
                clickedDoorFacing = (EnumFacing)otherHalfState.func_177229_b((IProperty)BlockDoor.field_176520_a);
            }
            if (clickedDoorHalf == BlockDoor.EnumDoorHalf.LOWER && otherHalfState.func_177230_c() instanceof BlockDoor) {
                clickedDoorHinge = (BlockDoor.EnumHingePosition)otherHalfState.func_177229_b((IProperty)BlockDoor.field_176521_M);
            }
            if (!(otherHalfState.func_177230_c() instanceof BlockDoor) || otherHalfState.func_177229_b((IProperty)BlockDoor.field_176523_O) == clickedDoorHalf) {
                pos1 = pos;
            } else if (!isOpen) {
                int xAdd = 0;
                int zAdd = 0;
                switch (clickedDoorFacing) {
                    default: {
                        zAdd = clickedDoorHinge == BlockDoor.EnumHingePosition.RIGHT ? -1 : 1;
                        break;
                    }
                    case NORTH: {
                        xAdd = clickedDoorHinge == BlockDoor.EnumHingePosition.RIGHT ? -1 : 1;
                        break;
                    }
                    case SOUTH: {
                        xAdd = clickedDoorHinge == BlockDoor.EnumHingePosition.RIGHT ? 1 : -1;
                        break;
                    }
                    case WEST: {
                        zAdd = clickedDoorHinge == BlockDoor.EnumHingePosition.RIGHT ? 1 : -1;
                    }
                }
                IBlockState otherTop = world.func_180495_p((clickedDoorHalf == BlockDoor.EnumDoorHalf.LOWER ? pos1 : pos).func_177982_a(xAdd, 0, zAdd));
                IBlockState otherBottom = world.func_180495_p((clickedDoorHalf == BlockDoor.EnumDoorHalf.LOWER ? pos : pos1).func_177982_a(xAdd, 0, zAdd));
                if (otherTop.func_177230_c() instanceof BlockDoor && otherBottom.func_177230_c() instanceof BlockDoor && !((Boolean)otherBottom.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue() && otherTop.func_177229_b((IProperty)BlockDoor.field_176521_M) == (clickedDoorHinge == BlockDoor.EnumHingePosition.RIGHT ? BlockDoor.EnumHingePosition.LEFT : BlockDoor.EnumHingePosition.RIGHT) && otherBottom.func_177229_b((IProperty)BlockDoor.field_176520_a) == clickedDoorFacing && otherTop.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER && otherBottom.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER) {
                    pos1 = pos1.func_177982_a(xAdd, 0, zAdd);
                }
            }
            if (LocksConfig.COMMON.automaticallyOrientPlacedLocks) {
                if (isOpen) {
                    EnumFacing curfacing = clickedDoorFacing;
                    switch (clickedDoorFacing) {
                        case NORTH: 
                        case SOUTH: {
                            curfacing = EnumFacing.WEST;
                            break;
                        }
                        case EAST: 
                        case WEST: {
                            curfacing = EnumFacing.SOUTH;
                            break;
                        }
                    }
                    placedOrientation = Orientation.fromDirection(curfacing.func_176734_d(), EnumFacing.NORTH);
                } else {
                    placedOrientation = Orientation.fromDirection(clickedDoorFacing.func_176734_d(), EnumFacing.NORTH);
                }
            }
        }
        ItemStack stack = player.func_184586_b(hand);
        ItemStack lockStack = stack.func_77946_l();
        lockStack.func_190920_e(1);
        if (!lockables.add(new Lockable(new Cuboid6i(pos1, pos), Lock.from(lockStack), placedOrientation, lockStack, world))) {
            return EnumActionResult.PASS;
        }
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!LockItem.isOpen(stack)) {
            return super.func_77659_a(world, player, hand);
        }
        LockItem.setOpen(stack, false);
        world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, LocksSoundEvents.PIN_MATCH, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return super.func_77659_a(world, player, hand);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> lines, ITooltipFlag flag) {
        super.func_77624_a(stack, world, lines, flag);
        int length = LocksUtil.hasKey(stack, KEY_LENGTH) ? (int)stack.func_77978_p().func_74771_c(KEY_LENGTH) : this.length;
        TextComponentTranslation txt = new TextComponentTranslation("locks.tooltip.length", new Object[]{ItemStack.field_111284_a.format(length)});
        txt.func_150256_b().func_150238_a(TextFormatting.DARK_GREEN);
        lines.add(txt.func_150254_d());
        float resist = (int)this.resistance;
        String resistString = ".tooltip.resistance.weak";
        if (resist >= 10.0f) {
            resistString = ".tooltip.resistance.strong";
        }
        if (resist >= 40.0f) {
            resistString = ".tooltip.resistance.supreme";
        }
        TextComponentTranslation txt2 = new TextComponentTranslation("locks" + resistString, new Object[0]);
        txt2.func_150256_b().func_150238_a(TextFormatting.DARK_GREEN);
        lines.add(txt2.func_150254_d());
    }
}

